﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NovelInterpreter.Exception
{
	/// <summary>
	/// 変更不可能なのに関わらず、変更が加えられた場合に投げられる例外
	/// </summary>
	public class NotChangeableException : System.Exception
	{
		/// <summary>
		/// 変更不可能な変数が変更された
		/// </summary>
		/// <param name="variableName">変数もしくは関数名など</param>
		public NotChangeableException(string variableName)
			: base("変更不可能な変数に変更が加えられました：" + variableName)
		{

		}
	}
}
